#pragma once
#include <vector>
#include "Structures.h"
#include "Hash.h"

class MeshLoader 
{
protected:
    std::vector<Node> VectorOfNodes;
    std::vector<FiniteElement> VectorOfFE;
    std::vector<BoundaryFiniteElement> VectorOfBFE;
public:
    virtual ~MeshLoader() = default;
    virtual void loadMesh(const std::string&) = 0;

    // ЧТОБЫ КОНСТАНТНЫЕ ФУНКЦИИ РАБОТАЛИ, НАДО ВОЗВРАЩАТЬ КОНСТАНТНУЮ ССЫЛКУ,
    // ИНАЧЕ ПРОТИВОРЕЧИЕ ВОЗНИКАЕТ: КОНСТАНТНАЯ ФУНКЦИЯ (КОТОРАЯ ГАРАНТИРУЕТ
    // НЕИЗМЕНЯЕМОСТЬ ОБЪЕКТА) ВОЗВРАЩАЕТ ССЫЛКУ, ПО КОТОРОЙ ЭТОТ ОБЪЕКТ МОЖНО ИЗМЕНИТЬ
    const std::vector<Node>& getVectorOfNodes() const;
    std::vector<FiniteElement>& getVectorOfFE();
    std::vector<BoundaryFiniteElement>& getVectorOfBFE();

    std::vector<FiniteElement> getFiniteElementsById(int x, int y, int z);
    std::vector<FiniteElement> getFiniteElementsByEdge(int x, int y) const;
    std::vector<FiniteElement> getFiniteElementsByMaterial(size_t MaterialId) const;
    std::set<size_t> getNodeSTLByBoundaryId(size_t boundaryId) const;
    std::vector<BoundaryFiniteElement> getBoundaryFiniteElementsSTLByBoundaryId(size_t boundaryId) const;
    std::vector<std::set<size_t>> getNeighbourSTL() const;
    Node getCenterNode(const Edge&);
    std::array<double, 3> getCenterEdge(const Edge& edge);
    void insertNodesInCenter();
    void PrintData();
};
